/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicPacketType;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public final class QuicHeaderParser
implements AutoCloseable {
    private final int maxTokenLength;
    private final int localConnectionIdLength;
    private final ByteBuf versionBuffer;
    private final ByteBuf typeBuffer;
    private final ByteBuf scidLenBuffer;
    private final ByteBuf scidBuffer;
    private final ByteBuf dcidLenBuffer;
    private final ByteBuf dcidBuffer;
    private final ByteBuf tokenBuffer;
    private final ByteBuf tokenLenBuffer;
    private boolean closed;

    public QuicHeaderParser(int maxTokenLength, int localConnectionIdLength) {
        Quic.ensureAvailability();
        this.maxTokenLength = ObjectUtil.checkPositiveOrZero(maxTokenLength, "maxTokenLength");
        this.localConnectionIdLength = ObjectUtil.checkPositiveOrZero(localConnectionIdLength, "localConnectionIdLength");
        this.versionBuffer = Quiche.allocateNativeOrder(4);
        this.typeBuffer = Quiche.allocateNativeOrder(1);
        this.scidLenBuffer = Quiche.allocateNativeOrder(4);
        this.dcidLenBuffer = Quiche.allocateNativeOrder(4);
        this.tokenLenBuffer = Quiche.allocateNativeOrder(4);
        this.scidBuffer = Unpooled.directBuffer(Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.dcidBuffer = Unpooled.directBuffer(Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.tokenBuffer = Unpooled.directBuffer(maxTokenLength);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.versionBuffer.release();
            this.typeBuffer.release();
            this.scidBuffer.release();
            this.scidLenBuffer.release();
            this.dcidBuffer.release();
            this.dcidLenBuffer.release();
            this.tokenLenBuffer.release();
            this.tokenBuffer.release();
        }
    }

    public void parse(InetSocketAddress sender, InetSocketAddress recipient, ByteBuf packet, QuicHeaderProcessor callback) throws Exception {
        if (this.closed) {
            throw new IllegalStateException("QuicHeaderParser is already closed");
        }
        long contentAddress = Quiche.memoryAddress(packet) + (long)packet.readerIndex();
        int contentReadable = packet.readableBytes();
        this.scidLenBuffer.setInt(0, Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.dcidLenBuffer.setInt(0, Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.tokenLenBuffer.setInt(0, this.maxTokenLength);
        int res = Quiche.quiche_header_info(contentAddress, contentReadable, this.localConnectionIdLength, Quiche.memoryAddress(this.versionBuffer), Quiche.memoryAddress(this.typeBuffer), Quiche.memoryAddress(this.scidBuffer), Quiche.memoryAddress(this.scidLenBuffer), Quiche.memoryAddress(this.dcidBuffer), Quiche.memoryAddress(this.dcidLenBuffer), Quiche.memoryAddress(this.tokenBuffer), Quiche.memoryAddress(this.tokenLenBuffer));
        if (res < 0) {
            throw Quiche.newException(res);
        }
        int version = this.versionBuffer.getInt(0);
        byte type = this.typeBuffer.getByte(0);
        int scidLen = this.scidLenBuffer.getInt(0);
        int dcidLen = this.dcidLenBuffer.getInt(0);
        int tokenLen = this.tokenLenBuffer.getInt(0);
        callback.process(sender, recipient, packet, QuicPacketType.of(type), version, this.scidBuffer.setIndex(0, scidLen), this.dcidBuffer.setIndex(0, dcidLen), this.tokenBuffer.setIndex(0, tokenLen));
    }

    public static interface QuicHeaderProcessor {
        public void process(InetSocketAddress var1, InetSocketAddress var2, ByteBuf var3, QuicPacketType var4, int var5, ByteBuf var6, ByteBuf var7, ByteBuf var8) throws Exception;
    }
}

