/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.QuicConnectionIdGenerator;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

final class HmacSignQuicConnectionIdGenerator
implements QuicConnectionIdGenerator {
    static final QuicConnectionIdGenerator INSTANCE = new HmacSignQuicConnectionIdGenerator();
    private static final byte[] randomKey = new byte[16];

    private HmacSignQuicConnectionIdGenerator() {
    }

    @Override
    public ByteBuffer newId(int length) {
        throw new UnsupportedOperationException("HmacSignQuicConnectionIdGenerator should always have an input to sign with");
    }

    @Override
    public ByteBuffer newId(ByteBuffer buffer, int length) {
        ObjectUtil.checkNotNull(buffer, "buffer");
        ObjectUtil.checkPositive(buffer.remaining(), "buffer");
        ObjectUtil.checkInRange(length, 0, this.maxConnectionIdLength(), "length");
        byte[] signBytes = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, randomKey).hmac(buffer);
        if (signBytes.length != length) {
            signBytes = Arrays.copyOf(signBytes, length);
        }
        return ByteBuffer.wrap(signBytes);
    }

    @Override
    public int maxConnectionIdLength() {
        return Quiche.QUICHE_MAX_CONN_ID_LEN;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    static {
        new SecureRandom().nextBytes(randomKey);
    }
}

