/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FormatSupport;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.types.GeoPoint;

public class GeoType
extends AbstractType<GeoType>
implements DataType,
FormatSupport,
Converter<GeoPoint> {
    public static final String ID = "geoPoint";
    public static final GeoType GLOBAL = new GeoType();
    private String latProperty = "lat";
    private String lonProperty = "lon";

    public GeoType latProperty(String property) {
        this.latProperty = property;
        return this;
    }

    public GeoType lonProperty(String property) {
        this.lonProperty = property;
        return this;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "\u5730\u7406\u4f4d\u7f6e";
    }

    public Map<String, Object> convertToMap(Object value) {
        HashMap<String, Object> mapGeoPoint = new HashMap<String, Object>();
        GeoPoint point = this.convert(value);
        if (point != null) {
            mapGeoPoint.put("lat", point.getLat());
            mapGeoPoint.put("lon", point.getLon());
        }
        return mapGeoPoint;
    }

    @Override
    public GeoPoint convert(Object value) {
        return GeoPoint.of(value);
    }

    @Override
    public ValidateResult validate(Object value) {
        GeoPoint geoPoint = this.convert(value);
        return geoPoint == null ? ValidateResult.fail("\u4e0d\u652f\u6301\u7684Geo\u683c\u5f0f:" + value) : ValidateResult.success(geoPoint);
    }

    @Override
    public String format(Object value) {
        GeoPoint geoPoint = this.convert(value);
        return String.valueOf(geoPoint);
    }

    public String getLatProperty() {
        return this.latProperty;
    }

    public String getLonProperty() {
        return this.lonProperty;
    }

    public void setLatProperty(String latProperty) {
        this.latProperty = latProperty;
    }

    public void setLonProperty(String lonProperty) {
        this.lonProperty = lonProperty;
    }
}

