/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public abstract class HandlerResultHandlerSupport
implements Ordered {
    private static final List<MediaType> ALL_APPLICATION_MEDIA_TYPES = Arrays.asList(MediaType.ALL, new MediaType("application"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RequestedContentTypeResolver contentTypeResolver;
    private final ReactiveAdapterRegistry adapterRegistry;
    private int order = Integer.MAX_VALUE;

    protected HandlerResultHandlerSupport(RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)contentTypeResolver, "RequestedContentTypeResolver is required");
        Assert.notNull((Object)adapterRegistry, "ReactiveAdapterRegistry is required");
        this.contentTypeResolver = contentTypeResolver;
        this.adapterRegistry = adapterRegistry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Nullable
    protected ReactiveAdapter getAdapter(HandlerResult result) {
        return this.getAdapterRegistry().getAdapter(result.getReturnType().resolve(), result.getReturnValue());
    }

    @Nullable
    protected MediaType selectMediaType(ServerWebExchange exchange2, Supplier<List<MediaType>> producibleTypesSupplier) {
        MediaType contentType2 = exchange2.getResponse().getHeaders().getContentType();
        if (contentType2 != null && contentType2.isConcrete()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(exchange2.getLogPrefix() + "Found 'Content-Type:" + contentType2 + "' in response");
            }
            return contentType2;
        }
        List<MediaType> acceptableTypes = this.getAcceptableTypes(exchange2);
        List<MediaType> producibleTypes = this.getProducibleTypes(exchange2, producibleTypesSupplier);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(this.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(result);
        MediaType selected = null;
        for (MediaType mediaType : result) {
            if (mediaType.isConcrete()) {
                selected = mediaType;
                break;
            }
            if (!mediaType.isPresentIn(ALL_APPLICATION_MEDIA_TYPES)) continue;
            selected = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selected != null) {
            selected = selected.removeQualityValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(exchange2.getLogPrefix() + "Using '" + selected + "' given " + acceptableTypes + " and supported " + producibleTypes);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(exchange2.getLogPrefix() + "No match for " + acceptableTypes + ", supported: " + producibleTypes);
        }
        return selected;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange2) {
        return this.getContentTypeResolver().resolveMediaTypes(exchange2);
    }

    private List<MediaType> getProducibleTypes(ServerWebExchange exchange2, Supplier<List<MediaType>> producibleTypesSupplier) {
        Set mediaTypes = (Set)exchange2.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return mediaTypes != null ? new ArrayList(mediaTypes) : producibleTypesSupplier.get();
    }

    private MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        Comparator<MediaType> comparator = MediaType.SPECIFICITY_COMPARATOR;
        return comparator.compare(acceptable, producible = producible.copyQualityValue(acceptable)) <= 0 ? acceptable : producible;
    }
}

