/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.mqtt;

import java.net.InetSocketAddress;
import java.time.Duration;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.NetClientCommandOption;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.mqtt.MqttClient;
import org.jetlinks.simulator.core.network.mqtt.MqttOptions;
import picocli.CommandLine;

@CommandLine.Command(name="connect", showDefaultValues=true, description={"Create new mqtt connection"}, headerHeading="%n", sortOptions=false)
class ConnectMqttCommand
extends AbstractCommand
implements Runnable {
    @CommandLine.Mixin
    MqttCommandOptions command;
    @CommandLine.Mixin
    private NetClientCommandOption common;

    ConnectMqttCommand() {
    }

    @Override
    public void run() {
        if (this.common != null) {
            this.common.apply(this.command);
        }
        this.printf("connecting %s", this.command);
        try {
            MqttClient client = MqttClient.connect(InetSocketAddress.createUnresolved(this.command.getHost(), this.command.getPort()), this.command).block(Duration.ofSeconds(10L));
            if (client != null) {
                this.main().connectionManager().addConnection(client);
                this.printf(" success!%n", new Object[0]);
                this.main().getCommandLine().execute("mqtt", "attach", client.getId());
            } else {
                this.printf(" error:%n", new Object[0]);
            }
        }
        catch (Throwable err) {
            this.printfError(" error: %s %n", ExceptionUtils.getErrorMessage(err));
        }
    }

    static class MqttCommandOptions
    extends MqttOptions {
        @CommandLine.Option(names={"--topics"}, description={"attach and subscribe topics"}, order=6)
        private String[] topics;

        MqttCommandOptions() {
        }

        @Override
        @CommandLine.Option(names={"-h", "--host"}, description={"host"}, order=1, defaultValue="127.0.0.1")
        public void setHost(String host) {
            super.setHost(host);
        }

        @Override
        @CommandLine.Option(names={"-p", "--port"}, description={"port"}, order=2, defaultValue="1883")
        public void setPort(int port) {
            super.setPort(port);
        }

        @CommandLine.Option(names={"-c", "--clientId"}, description={"MQTT clientId"}, order=3, defaultValue="mqtt-simulator")
        public void setClientId0(String clientId) {
            super.setClientId(clientId);
        }

        @CommandLine.Option(names={"-u", "--username"}, description={"MQTT username"}, order=4, defaultValue="mqtt-simulator")
        public void setUsername0(String username) {
            super.setUsername(username);
        }

        @CommandLine.Option(names={"-P", "--password"}, description={"MQTT password"}, order=5, defaultValue="mqtt-simulator")
        public void setPassword0(String password) {
            super.setPassword(password);
        }
    }
}

