/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.PathMatcher;

public class TopicUtils {
    public static final char PATH_SPLITTER = '/';
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ConcurrentMap<String, String[]> splitCache = new ConcurrentReferenceHashMap<String, String[]>(65535, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public static String convertToMqttTopic(String url) {
        CharSequence[] arr = TopicUtils.split(url);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            String str = arr[i2];
            if (str.startsWith("{") && str.endsWith("}")) {
                if (str.charAt(1) == '#') {
                    arr[i2] = "#";
                    continue;
                }
                arr[i2] = "+";
                continue;
            }
            if (str.equals("**")) {
                arr[i2] = "#";
                continue;
            }
            if (!str.equals("*")) continue;
            arr[i2] = "+";
        }
        return String.join((CharSequence)"/", arr);
    }

    public static boolean match(String pattern, String topic) {
        if (pattern.equals(topic)) {
            return true;
        }
        if (!(pattern.contains("*") || pattern.contains("#") || pattern.contains("+") || pattern.contains("{"))) {
            return false;
        }
        return pathMatcher.match(pattern.replace("#", "**").replace("+", "*"), topic);
    }

    public static Map<String, String> getPathVariables(String template, String topic) {
        try {
            return pathMatcher.extractUriTemplateVariables(template, topic);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static String[] split(String topic) {
        return TopicUtils.split(topic, false);
    }

    public static String[] split(String topic, boolean cache) {
        return cache ? splitCache.computeIfAbsent(topic, t -> t.split("/")) : topic.split("/");
    }

    private static boolean matchStrings(String str, String pattern) {
        return str.equals(pattern) || "*".equals(pattern) || "*".equals(str);
    }

    public static boolean match(String[] pattern, String[] topicParts) {
        String pattDir;
        int pathIdxStart;
        if (pattern.length == 0 && topicParts.length == 0) {
            return true;
        }
        int pattIdxStart = 0;
        int pattIdxEnd = pattern.length - 1;
        int pathIdxEnd = topicParts.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattDir = pattern[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (TopicUtils.matchStrings(pattDir, topicParts[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern[pattern.length - 1].equals("/") == topicParts[topicParts.length - 1].equals("/");
            }
            if (pattIdxStart == pattIdxEnd && pattern[pattIdxStart].equals("*") && topicParts[topicParts.length - 1].equals("/")) {
                return true;
            }
            for (int i2 = pattIdxStart; i2 <= pattIdxEnd; ++i2) {
                if (pattern[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if ("**".equals(topicParts[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattern[pattIdxEnd]).equals("**")) {
            if (!TopicUtils.matchStrings(pattDir, topicParts[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i3 = pattIdxStart; i3 <= pattIdxEnd; ++i3) {
                if (pattern[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = pattIdxStart + 1; i4 <= pattIdxEnd; ++i4) {
                if (!pattern[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattern[pattIdxStart + j + 1];
                    String subStr = topicParts[pathIdxStart + i5 + j];
                    if (!TopicUtils.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i6 = pattIdxStart; i6 <= pattIdxEnd; ++i6) {
            if (pattern[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    public static List<String> expand(String topic) {
        if (!topic.contains(",") && !topic.contains("{")) {
            return Collections.singletonList(topic);
        }
        if (topic.startsWith("/")) {
            topic = topic.substring(1);
        }
        String[] parts = topic.split("/", 2);
        String first = parts[0];
        ArrayList<String> expands = new ArrayList<String>();
        if (parts.length == 1) {
            for (String split2 : first.split(",")) {
                if (split2.startsWith("{") && split2.endsWith("}")) {
                    split2 = "*";
                }
                expands.add("/" + split2);
            }
            return expands;
        }
        List<String> nextTopics = TopicUtils.expand(parts[1]);
        for (String split3 : first.split(",")) {
            if (split3.startsWith("{") && split3.endsWith("}")) {
                split3 = "*";
            }
            for (String nextTopic : nextTopics) {
                StringJoiner joiner = new StringJoiner("");
                joiner.add("/");
                joiner.add(split3);
                if (!nextTopic.startsWith("/")) {
                    joiner.add("/");
                }
                joiner.add(nextTopic);
                expands.add(joiner.toString());
            }
        }
        return expands;
    }
}

