/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeProtocolSupports
implements ProtocolSupports {
    private final List<ProtocolSupports> supports = new CopyOnWriteArrayList<ProtocolSupports>();

    public void register(ProtocolSupports supports) {
        this.supports.add(supports);
    }

    @Override
    public boolean isSupport(String protocol) {
        for (ProtocolSupports support : this.supports) {
            if (!support.isSupport(protocol)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Mono<ProtocolSupport> getProtocol(String protocol) {
        for (ProtocolSupports support : this.supports) {
            if (!support.isSupport(protocol)) continue;
            return support.getProtocol(protocol);
        }
        return Mono.error(new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u534f\u8bae:" + protocol));
    }

    @Override
    public Flux<ProtocolSupport> getProtocols() {
        return Flux.fromIterable(this.supports).flatMap(ProtocolSupports::getProtocols);
    }
}

