/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentCyclicSequence<T>
implements Iterable<T>,
Iterator<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final AtomicInteger pos;
    private final Object[] elements;

    public ConcurrentCyclicSequence() {
        this(0, EMPTY_ARRAY);
    }

    @SafeVarargs
    public ConcurrentCyclicSequence(T ... elements) {
        this(0, (Object[])Arrays.copyOf(elements, elements.length, Object[].class));
    }

    private ConcurrentCyclicSequence(int pos, Object[] elements) {
        this.pos = new AtomicInteger(pos);
        this.elements = elements;
    }

    public int index() {
        return this.elements.length > 1 ? this.computeIndex(this.pos.get()) : 0;
    }

    private int computeIndex(int p) {
        return Math.abs(p % this.elements.length);
    }

    public T first() {
        return (T)(this.elements.length > 0 ? this.elements[0] : null);
    }

    public ConcurrentCyclicSequence<T> add(T element) {
        int len = this.elements.length;
        Object[] copy = Arrays.copyOf(this.elements, len + 1);
        copy[len] = element;
        return new ConcurrentCyclicSequence<T>(this.pos.get(), copy);
    }

    public ConcurrentCyclicSequence<T> remove(T element) {
        int len = this.elements.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!Objects.equals(element, this.elements[i2])) continue;
            if (len > 1) {
                Object[] copy = new Object[len - 1];
                System.arraycopy(this.elements, 0, copy, 0, i2);
                System.arraycopy(this.elements, i2 + 1, copy, i2, len - i2 - 1);
                return new ConcurrentCyclicSequence<T>(this.pos.get() % copy.length, copy);
            }
            return new ConcurrentCyclicSequence<T>();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        Object result = this.elements.length == 0 ? null : (this.elements.length == 1 ? this.elements[0] : this.elements[this.computeIndex(this.pos.getAndIncrement())]);
        return (T)result;
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(true);
    }

    public Iterator<T> iterator(boolean startAtBeginning) {
        int len = this.elements.length;
        Iterator iterator = len == 0 ? Collections.emptyIterator() : (len == 1 ? new SingletonIter() : new Iter(startAtBeginning ? 0 : this.pos.getAndIncrement()));
        return iterator;
    }

    private class Iter
    implements Iterator<T> {
        final int start;
        int cursor;

        public Iter(int start) {
            this.start = start;
            this.cursor = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ConcurrentCyclicSequence.this.elements.length;
        }

        @Override
        public T next() {
            if (this.cursor >= ConcurrentCyclicSequence.this.elements.length) {
                throw new NoSuchElementException();
            }
            return ConcurrentCyclicSequence.this.elements[ConcurrentCyclicSequence.this.computeIndex(this.start + this.cursor++)];
        }
    }

    private class SingletonIter
    implements Iterator<T> {
        boolean next = true;

        private SingletonIter() {
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public T next() {
            if (this.next) {
                this.next = false;
                return ConcurrentCyclicSequence.this.elements[0];
            }
            throw new NoSuchElementException();
        }
    }
}

