/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.jetlinks.core.utils.CompositeIterator;

public class CompositeCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Collection<E> first;
    protected final Collection<E> second;

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.first.contains(o) || this.second.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new CompositeIterator<E>(this.first.iterator(), this.second.iterator());
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int idx = 0;
        for (E e : this) {
            arr[idx++] = e;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        int idx = 0;
        for (E e : this) {
            a[idx++] = e;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new IllegalStateException();
    }

    @Override
    public boolean remove(Object o) {
        throw new IllegalStateException();
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        throw new IllegalStateException();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new IllegalStateException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new IllegalStateException();
    }

    @Override
    public void clear() {
        throw new IllegalStateException();
    }

    public String toString() {
        return "[" + this.first.toString() + "," + this.second.toString() + "]";
    }

    public CompositeCollection(Collection<E> first, Collection<E> second) {
        this.first = first;
        this.second = second;
    }
}

