/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public class ParameterContentTypeResolver
implements RequestedContentTypeResolver {
    private final Map<String, MediaType> mediaTypes = new ConcurrentHashMap<String, MediaType>(64);
    private String parameterName = "format";

    public ParameterContentTypeResolver(Map<String, MediaType> mediaTypes) {
        mediaTypes.forEach((key, value) -> this.mediaTypes.put(ParameterContentTypeResolver.formatKey(key), (MediaType)value));
    }

    private static String formatKey(String key) {
        return key.toLowerCase(Locale.ENGLISH);
    }

    public void setParameterName(String parameterName) {
        Assert.notNull((Object)parameterName, "'parameterName' is required");
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange2) throws NotAcceptableStatusException {
        String key = exchange2.getRequest().getQueryParams().getFirst(this.getParameterName());
        if (!StringUtils.hasText(key)) {
            return MEDIA_TYPE_ALL_LIST;
        }
        MediaType match = this.mediaTypes.get(key = ParameterContentTypeResolver.formatKey(key));
        if (match == null) {
            match = MediaTypeFactory.getMediaType("filename." + key).orElseThrow(() -> {
                ArrayList<MediaType> supported = new ArrayList<MediaType>(this.mediaTypes.values());
                return new NotAcceptableStatusException(supported);
            });
        }
        this.mediaTypes.putIfAbsent(key, match);
        return Collections.singletonList(match);
    }
}

