/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetlinks.core.metadata.types.GeoPoint;

public class GeoShape
implements Serializable {
    private Type type;
    private List<Object> coordinates;

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type.name());
        if (this.type == Type.GeometryCollection) {
            map.put("geometries", this.coordinates);
        } else {
            map.put("coordinates", this.coordinates);
        }
        return map;
    }

    public String toString() {
        return JSON.toJSONString(this.toMap());
    }

    public static GeoShape point(GeoPoint point) {
        return GeoShape.of(Type.Point, Arrays.asList(point.getLon(), point.getLat()));
    }

    public static GeoShape multiPoint(GeoPoint ... points) {
        return GeoShape.of(Type.MultiPoint, GeoShape.toPointList(Arrays.asList(points)));
    }

    public static GeoShape lineString(GeoPoint ... points) {
        return GeoShape.of(Type.LineString, GeoShape.toPointList(Arrays.asList(points)));
    }

    @SafeVarargs
    public static GeoShape multiLineString(List<GeoPoint> ... points) {
        return GeoShape.of(Type.MultiLineString, Arrays.stream(points).map(GeoShape::toPointList).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static GeoShape polygon(List<GeoPoint> ... points) {
        return GeoShape.of(Type.Polygon, Arrays.stream(points).map(GeoShape::toPointList).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static GeoShape multiPolygon(List<List<GeoPoint>> ... points) {
        return GeoShape.of(Type.MultiPolygon, Arrays.stream(points).map(list -> list.stream().map(GeoShape::toPointList).collect(Collectors.toList())).collect(Collectors.toList()));
    }

    public static GeoShape collection(GeoShape ... shapes) {
        return GeoShape.of(Type.GeometryCollection, Arrays.stream(shapes).map(GeoShape::toMap).collect(Collectors.toList()));
    }

    private static List<Object> toPointList(Iterable<GeoPoint> points) {
        return StreamSupport.stream(points.spliterator(), false).map(p -> Arrays.asList(p.getLon(), p.getLat())).collect(Collectors.toList());
    }

    public static GeoShape of(Object value) {
        if (value instanceof GeoShape) {
            return (GeoShape)value;
        }
        if (value instanceof GeoPoint) {
            return GeoShape.fromPoint((GeoPoint)value);
        }
        if (value instanceof String && ((String)value).startsWith("{")) {
            value = JSON.parseObject(String.valueOf(value));
        }
        if (value instanceof Map) {
            return GeoShape.of((Map)value);
        }
        throw new IllegalArgumentException("unsupported GeoShape:" + value);
    }

    public static GeoShape of(Map<String, Object> map) {
        GeoShape shape = new GeoShape();
        shape.type = Type.of(map.get("type"));
        shape.coordinates = shape.type.parseCoordinates(map.get("coordinates"));
        return shape;
    }

    public static GeoShape fromPoint(GeoPoint point) {
        GeoShape shape = new GeoShape();
        shape.type = Type.Point;
        shape.coordinates = new ArrayList<Double>(Arrays.asList(point.getLon(), point.getLat()));
        return shape;
    }

    public Type getType() {
        return this.type;
    }

    public List<Object> getCoordinates() {
        return this.coordinates;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setCoordinates(List<Object> coordinates) {
        this.coordinates = coordinates;
    }

    private GeoShape(Type type, List<Object> coordinates) {
        this.type = type;
        this.coordinates = coordinates;
    }

    public static GeoShape of(Type type, List<Object> coordinates) {
        return new GeoShape(type, coordinates);
    }

    public GeoShape() {
    }

    public static enum Type {
        Point,
        MultiPoint,
        LineString,
        MultiLineString,
        Polygon,
        MultiPolygon,
        GeometryCollection;


        public static Type of(Object val) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(String.valueOf(val))) continue;
                return value;
            }
            throw new IllegalArgumentException("unsupported GeoShape type:" + val);
        }

        public List<Object> parseCoordinates(Object coordinates) {
            if (coordinates instanceof Collection) {
                return new ArrayList<Object>((Collection)coordinates);
            }
            if (coordinates instanceof String) {
                if (((String)coordinates).startsWith("[")) {
                    return JSON.parseArray(String.valueOf(coordinates));
                }
                return new ArrayList<Object>(Arrays.asList(((String)coordinates).split(",")));
            }
            throw new IllegalArgumentException("unsupported coordinates type :" + coordinates);
        }
    }
}

