/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.IOException;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.AndSignaturePattern;
import org.aspectj.weaver.patterns.ISignaturePattern;
import org.aspectj.weaver.patterns.NotSignaturePattern;
import org.aspectj.weaver.patterns.OrSignaturePattern;
import org.aspectj.weaver.patterns.SignaturePattern;

public abstract class AbstractSignaturePattern
implements ISignaturePattern {
    protected void writePlaceholderLocation(CompressingDataOutputStream s2) throws IOException {
        s2.writeInt(0);
        s2.writeInt(0);
    }

    public static ISignaturePattern readCompoundSignaturePattern(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        byte key = s2.readByte();
        switch (key) {
            case 1: {
                return SignaturePattern.read(s2, context);
            }
            case 4: {
                return AndSignaturePattern.readAndSignaturePattern(s2, context);
            }
            case 3: {
                return OrSignaturePattern.readOrSignaturePattern(s2, context);
            }
            case 2: {
                return NotSignaturePattern.readNotSignaturePattern(s2, context);
            }
        }
        throw new BCException("unknown SignatureTypePattern kind: " + key);
    }

    public static void writeCompoundSignaturePattern(CompressingDataOutputStream s2, ISignaturePattern sigPattern) throws IOException {
        if (sigPattern instanceof SignaturePattern) {
            s2.writeByte(1);
            ((SignaturePattern)sigPattern).write(s2);
        } else if (sigPattern instanceof AndSignaturePattern) {
            AndSignaturePattern andSignaturePattern = (AndSignaturePattern)sigPattern;
            s2.writeByte(4);
            AbstractSignaturePattern.writeCompoundSignaturePattern(s2, andSignaturePattern.getLeft());
            AbstractSignaturePattern.writeCompoundSignaturePattern(s2, andSignaturePattern.getRight());
            s2.writeInt(0);
            s2.writeInt(0);
        } else if (sigPattern instanceof OrSignaturePattern) {
            OrSignaturePattern orSignaturePattern = (OrSignaturePattern)sigPattern;
            s2.writeByte(3);
            AbstractSignaturePattern.writeCompoundSignaturePattern(s2, orSignaturePattern.getLeft());
            AbstractSignaturePattern.writeCompoundSignaturePattern(s2, orSignaturePattern.getRight());
            s2.writeInt(0);
            s2.writeInt(0);
        } else {
            NotSignaturePattern notSignaturePattern = (NotSignaturePattern)sigPattern;
            s2.writeByte(2);
            AbstractSignaturePattern.writeCompoundSignaturePattern(s2, notSignaturePattern.getNegated());
            s2.writeInt(0);
            s2.writeInt(0);
        }
    }
}

